### MCP란?
[배경지식](https://channel.io/ko/blog/articles/what-is-mcp-52c77e72)
- AI가 우리가 사용 중인 도구나 인프라에 접근해 데이터를 처리하는 프로토콜
- 단, AI가 직접 우리의 서버나 도구에 접근할 수 없기 때문에 로컬 환경에서 접속을 돕는 `클라이언트 서버` 필요

### 1. [Docker Desktop 설치](https://www.docker.com/get-started/)
- `클라이언트 서버`는 Docker를 통해 쉽게 구동 가능
- `Download Docker Desktop` > `Download For Windows = AMD64` 다운로드
- 패키지 실행 > 기본 옵션으로 설치 > `Close and reboot` 선택
- WSL 하위 패키지 설치 진행 (명령프롬프트를 읽고 지시대로 이행)
  * Docker의 엔진으로 작동되기 때문에 WSL이 미설치된 경우 사용할 수 없음.
- WSL 설치 이후 도커 기본 설정 진행 (로그인을 요구하는 경우 `Skip` 가능)

### 2. [Claude Desktop 설치](https://claude.ai/download)
- `Claude` 서비스는 웹으로 사용 가능한 서비스이지만 MCP와 함께 사용하려면 데스크톱 설치 필요
- 데스크톱 설치 이후 구동
- `config` 수정 필요 (vscode가 설치되어 있지 않다면 직접 파일탐색기 접근필요)

```sh
# 명령어
notepad %APPDATA%\Claude\claude_desktop_config.json
```

```sh
# 아래 내용 붙여넣기 후 저장
{
  "mcpServers": {
    "postgres": {
      "command": "docker",
      "args": [
        "run", 
        "-i", 
        "--rm", 
        "mcp/postgres", 
        "postgresql://<username>:<password>@<host>:<port>/<dbname>"] # 이 부분은 직접 수정
    }
  }
}

### 3. Claude Desktop 실행 후 테이블 명령 조회 명령어 실행해 테스트